package gov.va.med.mhv.usermgmt.bizobj;

import gov.va.med.mhv.usermgmt.enumeration.CountryEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.PasswordHintQuestionEnumeration;
import gov.va.med.mhv.usermgmt.messages.UserManagementMessages;
import gov.va.med.mhv.usermgmt.transfer.EmergencyContact;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;
import gov.va.med.mhv.usermgmt.transfer.UserProfileDeactivationReason;
import gov.va.med.mhv.usermgmt.transfer.UserProfileDeactivationReasonPK;
import gov.va.med.mhv.usermgmt.util.MessageKeys;
import gov.va.med.mhv.usermgmt.util.mvi.MviConstants;

import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.tigris.atlas.format.SsnFormatter;
import org.tigris.atlas.validate.Validations;
import org.tigris.atlas.validate.Validator;
import org.tigris.atlas.validate.ZipCodeValidator;

/**
 * Business object for the UserProfile application entity
 *
 * Generated Skeleton Code
 */

public class UserProfileBO extends UserProfileBaseBO {

	protected void complexValidation() {
		validateUniqueUser();
		validatePasswordHints();
//		validatePasswordHintAnswers();
		validateStateAndProvinceAndCountry();
		validateContactMethodProvided();
		validateRequiredPatientInfo();
		validateUserType();
		validatePostalCode();
		validateTermAndConditionAcceptance();
		validateHealthInterests();
		validateAtMostOnePrimaryEmergencyContact();
	}

	//Admin Portal_CodeCR1959 - React/Deact Impl
	public void setUserProfileValuesForReactivation(UserProfile to) {
		if ((to != null) && (this != null)) {			
			this.setId(to.getId());
			this.setCreatedDate(to.getCreatedDate());
			this.setInterestHeart(to.getInterestHeart());
			this.setIsHealthCareProvider(to.getIsHealthCareProvider());
			this.setIsEmployee(to.getIsEmployee());
			this.setAddressStreet1(to.getAddressStreet1());
			this.setIsPatientAdvocate(to.getIsPatientAdvocate());
			this.setAutoAuthDate(to.getAutoAuthDate());
			this.setProofInstitutionId(to.getProofInstitutionId());
			this.setInterestStress(to.getInterestStress());
			this.setInterestPTSD(to.getInterestPTSD());
			this.setFirstName(to.getFirstName());
			this.setAddressStreet2(to.getAddressStreet2());
			this.setInterestDepression(to.getInterestDepression());
			this.setAlternateAddressProvince(to.getAlternateAddressProvince());
			this.setEmailHealthAwareness(to.getEmailHealthAwareness());
			this.setPhysicalProof(to.getPhysicalProof());
			this.setAddressCity(to.getAddressCity());
			this.setPasswordHintAnswer1(to.getPasswordHintAnswer1());
			this.setBloodType(to.getBloodType());
			this.setIsPatient(to.getIsPatient());
			this.setMiddleName(to.getMiddleName());
			this.setGender(to.getGender());
			this.setInterestDiabetes(to.getInterestDiabetes());
			this.setUserName(to.getUserName());
			this.setLockDate(to.getLockDate());
			this.setInterestSmoking(to.getInterestSmoking());
			this.setProofLevelDate(to.getProofLevelDate());
			this.setIsMPIControlled(to.getIsMPIControlled());
			this.setContactInfoEmail(to.getContactInfoEmail());
			this.setPasswordHintQuestion1(to.getPasswordHintQuestion1());
			this.setAlternateAddressPostalCode(to.getAlternateAddressPostalCode());
			this.setAddressPostalCode(to.getAddressPostalCode());
			this.setRxAgreementSigned(to.getRxAgreementSigned());
			this.setAddressCountry(to.getAddressCountry());
			this.setContactInfoHomePhone(to.getContactInfoHomePhone());
			this.setContactInfoMobilePhone(to.getContactInfoMobilePhone());
			this.setContactInfoWorkPhone(to.getContactInfoWorkPhone());
			this.setContactInfoPager(to.getContactInfoPager());
			this.setAlternateAddressCity(to.getAlternateAddressCity());
			this.setPasswordLastChanged(to.getPasswordLastChanged());
			this.setConfirmationLockOut(to.getConfirmationLockOut());
			this.setTitle(to.getTitle());
			this.setInterestExercise(to.getInterestExercise());
			this.setMaritalStatus(to.getMaritalStatus());
			this.setInterestAlcohol(to.getInterestAlcohol());
			this.setPasswordLockOut(to.getPasswordLockOut());
			this.setUserAlias(to.getUserAlias());
			this.setAutoAuth(to.getAutoAuth());
			this.setEmailCredentials(to.getEmailCredentials());
			this.setInterestReminder(to.getInterestReminder());
			this.setAlternateAddressStreet1(to.getAlternateAddressStreet1());
			this.setSuffix(to.getSuffix());
			this.setPasswordHintQuestion2(to.getPasswordHintQuestion2());
			this.setIsOrganDonor(to.getIsOrganDonor());
			this.setIsAdministrator(to.getIsAdministrator());
			this.setAcceptTerms(to.getAcceptTerms());
			this.setProofLevel(to.getProofLevel());
			this.setAlternateAddressState(to.getAlternateAddressState());
			this.setTemporaryPassword(to.getTemporaryPassword());
			this.setAcceptSMTerms(to.getAcceptSMTerms());
			this.setRxAgreementDate(to.getRxAgreementDate());
			this.setSsn(to.getSsn());
			this.setAcceptDisclaimer(to.getAcceptDisclaimer());
			this.setOrientationVideoView(to.getOrientationVideoView());
			this.setInterestMilitaryRelated(to.getInterestMilitaryRelated());
			this.setLockCount(to.getLockCount());
			this.setAddressProvince(to.getAddressProvince());
			this.setIsVeteran(to.getIsVeteran());
			this.setAddressState(to.getAddressState());
			this.setAlternateAddressCountry(to.getAlternateAddressCountry());
			this.setMhvId(to.getMhvId());
			this.setAlternateAddressStreet2(to.getAlternateAddressStreet2());
			this.setBirthDate(to.getBirthDate());
			this.setLastName(to.getLastName());
			this.setAcceptPrivacy(to.getAcceptPrivacy());
			this.setPasswordHintAnswer2(to.getPasswordHintAnswer2());
			this.setInterestDiet(to.getInterestDiet());
			this.setContactInfoContactMethod(to.getContactInfoContactMethod());
			this.setEhrAccess(to.getEhrAccess());
			this.setCurrentOccupation(to.getCurrentOccupation());
			this.setInterestBloodPressure(to.getInterestBloodPressure());
			this.setParticipationFormSign(to.getParticipationFormSign());
			this.setIsOther(to.getIsOther());
			this.setLastLogin(to.getLastLogin());
			this.setContactInfoFax(to.getContactInfoFax());
			this.setOplock(to.getOplock());

			//pull over composites:

			//pull over parent:

			//pull over relations:
			//get the set of to relations (transient view):		
			Set	emergencyContactToSet = to.getEmergencyContacts();
			
			if ((emergencyContactToSet != null) && (emergencyContactToSet.size() > 0)) {
				EmergencyContact emergencyContactTo;
				//get the set of bo relations (persistence view).  Turn this set into a
				//key-value pair so we can compare PrimaryKey instances:
				EmergencyContactBO emergencyContactBo;			
				Set	emergencyContactBoSet = this.getEmergencyContacts();
				int size = (emergencyContactBoSet != null) ? emergencyContactBoSet.size() : 0;
				Map emergencyContactKeyToBoMap = new HashMap((int)(size * 1.25));
				if (size > 0) {
					Iterator emergencyContactBoSetIterator = emergencyContactBoSet.iterator();
					while (emergencyContactBoSetIterator.hasNext()) {
						emergencyContactBo = (EmergencyContactBO)emergencyContactBoSetIterator.next();
						emergencyContactKeyToBoMap.put(emergencyContactBo.getKey(), emergencyContactBo);
						
					}
				}
				
				
				//iterate over the children and perform the correct CRUD action:
				Iterator emergencyContactToSetIterator = emergencyContactToSet.iterator();
				while (emergencyContactToSetIterator.hasNext()) {
					emergencyContactTo = (EmergencyContact)emergencyContactToSetIterator.next();
					emergencyContactBo = (EmergencyContactBO)emergencyContactKeyToBoMap.get(emergencyContactTo.getKey());
					
					if (emergencyContactBo == null) {
						//this instance isn't known to the BO, so it is a create:
						emergencyContactBo = new EmergencyContactBO();
						this.addEmergencyContact(emergencyContactBo);					
						
					} else {
						//remove the reference from the temp. BO map.  Anything left in this map will
						//be removed from the BO:
						emergencyContactKeyToBoMap.remove(emergencyContactBo.getKey());
					}
					
					//update this instance with the TO:
					emergencyContactBo.setEmergencyContactValues(emergencyContactTo);
											
				}
				
				//loop over any remaining BOs and delete them:
				if (emergencyContactKeyToBoMap.size() > 0) {
					Iterator emergencyContactKeyToBoMapIterator = emergencyContactKeyToBoMap.values().iterator();
					while (emergencyContactKeyToBoMapIterator.hasNext()) {
						emergencyContactBoSet.remove(emergencyContactKeyToBoMapIterator.next());
					
					}
				}
				
			} else {
				this.getEmergencyContacts().clear();
			
			}

			//pull over references:
			this.setDeactivationReason(null);
		}
	}
	
	private void generateMhvId() {
		if (StringUtils.isNotBlank(getMhvId())) {
		// Only generate on an insert.
			return;
		}

		String firstInitial = StringUtils.upperCase(getFirstName().substring(0,
            1));
		String lastInitial = StringUtils.upperCase(getLastName().substring(0,
            1));

		StringBuffer mhvId = new StringBuffer("M");
		mhvId.append(firstInitial);
		mhvId.append(lastInitial);
		mhvId.append(getGender().getName().charAt(0));
		mhvId.append('-');

		Calendar calendar = Calendar.getInstance();
		calendar.setTime(getBirthDate());
		String bdYear = String.valueOf(calendar.get(Calendar.YEAR));
		mhvId.append(bdYear.substring(2));
		mhvId.append('-');
		mhvId.append(generateRandomNumber(4));

		setMhvId(mhvId.toString());
	}

	private void validateUniqueUser() {
		if (BooleanUtils.isTrue(getIsMPIControlled())) {
			// if MPI controlled validation should be skipped
			return;
		}
		String firstName = StringUtils.lowerCase(getFirstName());
		String lastName = StringUtils.lowerCase(getLastName());

		if (getId() != null) {
		    if (getProfileByNameBirthDateSsnExcludeId(firstName, lastName,
                    getBirthDate(), getSsn(),getId()).size() > 0)
            {
			    //addError(UserManagementMessages.USER_ALREADY_IN_USE);
			    addError(UserManagementMessages.USER_ALREADY_IN_USE, new String[]{MviConstants.FORGOTUSERID_URL, MviConstants.FORGOTPASSWORD_URL, MviConstants.CONTACT_LOGGEDMHV_URL});
			    
            } else {
			    return;
            }
		 } else if (getProfileByNameBirthDateSsn(firstName, lastName,
                getBirthDate(), getSsn()).size() > 0)
         {
				//addError(UserManagementMessages.USER_ALREADY_IN_USE);
			 addError(UserManagementMessages.USER_ALREADY_IN_USE, new String[]{MviConstants.FORGOTUSERID_URL, MviConstants.FORGOTPASSWORD_URL, MviConstants.CONTACTMHV_URL});
         }
	}

	@Override
	protected void validateFirstName() {
		if (BooleanUtils.isTrue(getIsMPIControlled())) {
			// if MPI controlled validation should be skipped
			// but ensure value is not null
			return;
		}
		String value = getFirstName();
		//check requiredness:
		if( StringUtils.isBlank(value)) {
			Validations.validateRequired(value, "firstName", "First Name",
					getMessages());
			//no need to continue:
			return;
		}
	}


	@Override
	protected void validateLastName() {
		if (BooleanUtils.isTrue(getIsMPIControlled())) {
			// if MPI controlled validation should be skipped
			// but ensure value is not null
			return;
		}
		String value = getLastName();
		//US8.16 & US7.16 - Last name is not blank and contains no numbers.
		//Checking to see if there is any digit in the last name. If it is, add an error message.
		if( value!=null && containsDigit(value)) {
			Validations.validateRequired(value, "lastName", "Last Name", getMessages());
	        addError(UserManagementMessages.LAST_NAME_NUMBERS);

			return;
		}
		super.validateLastName();
	}	
	
	//US8.16 & US7.16 - Last name is not blank and contains no numbers.
	//The method to check the if there is a digit in a string.
	private boolean containsDigit(String str) {
		for(int i=0; i < str.length();i++) {
			if(Character.isDigit(str.charAt(i))) {
				return true;
			}
		}
		return false;
		
	}

	@Override
	protected void validateMiddleName() {
		if (BooleanUtils.isTrue(getIsMPIControlled())) {
			// if MPI controlled validation should be skipped
			return;
		}
		super.validateMiddleName();
	}

	@Override
	protected void validateBirthDate() {
		if (BooleanUtils.isTrue(getIsMPIControlled())) {
			// if MPI controlled validation should be skipped
			return;
		}
		super.validateBirthDate();
	}

	@Override
	protected void validateGender() {
		if (BooleanUtils.isTrue(getIsMPIControlled())) {
			// if MPI controlled validation should be skipped
			return;
		}
		if( getGender() == null ) {
			Validations.validateRequired(getGender(), "gender", "Gender", 
				getMessages());
			//no need to continue:
			return;
		}		
		
		super.validateGender();
	}

	@Override
	protected void validateSuffix() {
		if (BooleanUtils.isTrue(getIsMPIControlled())) {
			// if MPI controlled validation should be skipped
			return;
		}
		super.validateSuffix();
	}

	@Override
	protected void validateTitle() {
		if (BooleanUtils.isTrue(getIsMPIControlled())) {
			// if MPI controlled validation should be skipped
			return;
		}
		super.validateTitle();
	}

	private void validateRequiredPatientInfo() {
		if (BooleanUtils.isTrue(getIsMPIControlled())) {
			// if MPI controlled validation should be skipped
			// but ensure value is not null
			return;
		}
		if (isPatient()) {
			if (StringUtils.isBlank(getSsn())) {
               // Typically SSN should be given
               addError(UserManagementMessages.SSN_REQUIRED_FOR_PATIENT);
			}
		} else if (isVeteran()) {
			//US8.15 & US7.15 - SSN is required if Relationship to VA is or has changed to Veteran and/or VA Patient. 
			if (StringUtils.isBlank(getSsn())) {
               // Typically SSN should be given
               addError(UserManagementMessages.SSN_REQUIRED_FOR_VETERAN);
			}
		}
	}

	private void validatePasswordHints() {
		if ((getPasswordHintQuestion1()==null)
            || (getPasswordHintQuestion2()==null))
        {
			return;
		}

		if (getPasswordHintQuestion1().equals(getPasswordHintQuestion2())) {
			addError(UserManagementMessages.HINTS_MUST_DIFFER, new Object[] {});
		}
	}


	private void validateStateAndProvinceAndCountry() {
		if (StringUtils.isNotBlank(getAddressProvince())
            && (getAddressState() != null))
        {
			addError(UserManagementMessages.PROVINCE_OR_STATE, new Object[] {});
		}

		if (getAddressCountry() != null) {
			if (CountryEnumeration.UNITED_STATES.equals(getAddressCountry().
                getName()))
            {
				if (getAddressState() == null) {
					addError(UserManagementMessages.STATE_REQUIRED,
                        new Object[] {});
				}
			} else if (CountryEnumeration.CANADA.equals(getAddressCountry().
                getName()))
            {
				if (StringUtils.isBlank(getAddressProvince())) {
					addError(UserManagementMessages.PROVINCE_REQUIRED,
                        new Object[] {});
				}
			}
		} else if ((getAddressState() != null) || StringUtils.isNotBlank(
            getAddressProvince()))
        {
			addError(UserManagementMessages.COUNTRY_REQUIRED, new Object[] {});
		}
	}

	private void validatePostalCode() {
		if ((getAddressCountry() != null)
            && StringUtils.isNotBlank(getAddressPostalCode())
            && getAddressCountry().equals(CountryEnumeration.UNITED_STATES))
        {
			Validator zipCodeValidator = new ZipCodeValidator();
			getMessages().addMessages(zipCodeValidator.validate(
                getAddressPostalCode(), new String [] {"addressPostalCode"},
                new Object [] {"addressPostalCode"}));
		}
	}

	private void validateContactMethodProvided() {

		if (getContactInfoContactMethod() == null) {
			return;
		}

		String contactMethodMethodName = "getContactInfo" +
            getContactInfoContactMethod().getName();
		try {
			Method contactMethodMethod = getClass().getMethod(
				contactMethodMethodName, (Class[]) null);
			String contactNumber = (String) contactMethodMethod.invoke(this,
				(Object[]) null);
			if (StringUtils.isBlank(contactNumber)) {
				addError(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED,
				    new Object[] {});
			}
		} catch (Exception e) {
			addError(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED,
                new Object[] {});
		}

	}

	private void validateTermAndConditionAcceptance() {
		if ((getAcceptTerms() == null)
            || !getAcceptTerms().booleanValue())
        {
			addError(UserManagementMessages.MUST_ACCEPT_TERMS,
                new Object[] {});
		}

		if ((getAcceptPrivacy() == null)
            || !getAcceptPrivacy().booleanValue())
        {
			addError(UserManagementMessages.MUST_ACCEPT_PRIVACY,
                new Object[] {});
		}
	}

	private void validateHealthInterests() {
		if (getEmailHealthAwareness() != null &&
			getEmailHealthAwareness().booleanValue() &&
			StringUtils.isBlank(getContactInfoEmail()))
        {
			addError(UserManagementMessages.HEALTH_INTEREST_EMAIL_REQUIRED,
                new Object[] {});
		}
	}

	private void validateAtMostOnePrimaryEmergencyContact() {
		int numberOfPrimaryContacts = 0;
		Set contacts = getEmergencyContacts();
		if (contacts != null) {
			for (Object c: contacts) {
				if (BooleanUtils.isTrue(((EmergencyContactBO) c).
					getIsPrimary()))
				{
					numberOfPrimaryContacts++;
				}
			}
		}

		if (numberOfPrimaryContacts > 1) {
			addError(MessageKeys.TOO_MANY_PRIMARY_CONTACTS,
                new Object[] { "" });
		}
	}


   /**
    * Generates a random integral number
    *
    * @return int The value of the randomly generated number.
    */
	private static int getRandomDigit() {
		int num = new Double(Math.random() * 10).intValue();
		return num;
	}

    /**
	 * Generates a random number with specified length.
	 *
	 * @return String Generated random number with specified length.
	 */
	public static String generateRandomNumber(int len) {
		StringBuffer sb = new StringBuffer(len);

		for (int i = 0; i < len; i++) {
			sb.append(getRandomDigit());
		}
		return sb.toString();
	}

	public boolean isPatient() {
		return (getIsPatient() == null) ? false : getIsPatient().booleanValue();
	}

	public boolean isVeteran() {
		return (getIsVeteran() == null) ? false : getIsVeteran().booleanValue();
	}

	public boolean isAdministrator() {
		return (getIsAdministrator() == null) ? false
            : getIsAdministrator().booleanValue();
	}

	public boolean isEmployee() {
		return (getIsEmployee() == null) ? false
            : getIsEmployee().booleanValue();
	}

	public boolean isPatientAdvocate() {
		return (getIsPatientAdvocate() == null) ? false
            : getIsPatientAdvocate().booleanValue();
	}

	public boolean isHealthCareProvider() {
		return (getIsHealthCareProvider() == null) ? false
            : getIsHealthCareProvider().booleanValue();
	}

	public boolean isOther() {
		return (getIsOther() == null) ? false : getIsOther().booleanValue();
	}

	private void validateUserType() {

		if (isPatient() || isVeteran() || isEmployee() || isOther()
            || isPatientAdvocate() || isHealthCareProvider()
            || isAdministrator())
        {
			return;
		}
		addError(UserManagementMessages.MISSING_USER_TYPE, new Object[] {});

	}

	protected void normalize() {
		setSsn(SsnFormatter.format(getSsn()));
		generateMhvId();
	}


	public void validateMatchingSSN(String verifySsn) {
		if (! StringUtils.equals(getSsn(), verifySsn)) {
			addError(UserManagementMessages.SSN_DOES_NOT_MATCH);
		}
	}

	//CR2161 and CR2162 Kumar,Vyasa started here
	public void validatePasswordHintAnswers(){
		if ((getPasswordHintAnswer1() == null) || (getPasswordHintAnswer2() == null))    {
				return;
			}
		if (getPasswordHintAnswer1().trim().equalsIgnoreCase(getPasswordHintAnswer2().trim())) {
	//		addError(UserManagementMessages.HINTS_ANSWER_MUST_DIFFER, new Object[] {});
			addError(UserManagementMessages.HINTS_ANSWER_MUST_DIFFER);
		}
//		PasswordHintQuestionEnumeration value = getPasswordHintQuestion1();

	//	value.getName();
		if ((getPasswordHintQuestion1().getName()).equalsIgnoreCase(getPasswordHintQuestion2().getName())) {
			//		addError(UserManagementMessages.HINTS_ANSWER_MUST_DIFFER, new Object[] {});
					addError(UserManagementMessages.HINTS_MUST_DIFFER);
				}
		
	}
	//CR2161 and CR2162 Kumar,Vyasa ended here
	
}
